# Construct troop quality variables
# troop quality = military expanditure / military personnel
# military personnel (milper): world bank world development indicators = IISS The Military Balance
# military expenditure: SIPRI data

wdilist <- c("MS.MIL.TOTL.P1") # Armed forces personnel, total

# Extract latest version of desired variables from WDI.
wdi <- WDI(country="all", indicator = wdilist, extra = FALSE,
           start = 1989, end = 2009)

wdi$actorid <- countrycode(wdi$iso2c, "iso2c", "cown", warn = T)
wdi$actorid[wdi$country=="Kosovo"] <- 347 # Kosovo 
wdi$actorid[wdi$country=="Serbia"] <- 345 # Serbia (Yugoslavia)
wdi$actorid[wdi$country=="South Sudan"] <- 626 # South Sudan (to be sure that it does not match Sudan)
wdi$actorid[wdi$country=="Yemen, Rep."] <- 678 # used in SVAC for Yemen (In CoW: Yemen Arab Republic!)
wdi$actorid[wdi$country=="South Africa"] <- 560 # South Africa
wdi$actorid[wdi$country=="Zimbabwe"] <- 552 # Zimbabwe

wdi <- rename(wdi, c("MS.MIL.TOTL.P1"="milper"))

wdi <- subset(wdi, is.na(actorid)==FALSE, 
              select=c(actorid, year, milper))

## OBSOLETE
##
## Import HUGHE WorldBank WDI dataset, process it, extract military personnel variable, and save handleable dataset 
## (one time process)
##

#wb_wdi <- read.csv("Daten/World Bank WDI/WDI_Data.csv", sep = ",", header = T)
#wb_wdi <- subset(wb_wdi, Indicator.Name=="Armed forces personnel, total", 
#                 select = c(Country.Code, X1989, X1990, X1991, X1992, X1993, X1994,
#                            X1995, X1996, X1997, X1998, X1999, X2000, X2001, X2002, 
#                            X2003, X2004, X2005, X2006, X2007, X2008, X2009))
#wb_wdi <- rename(wb_wdi, replace = c("X1989"=1989, "X1990"=1990, "X1991"=1991, "X1992"=1992, "X1993"=1993, 
#                                       "X1994"=1994, "X1995"=1995, "X1996"=1996, "X1997"=1997, "X1998"=1998, 
#                                       "X1999"=1999, "X2000"=2000, "X2001"=2001, "X2002"=2002, "X2003"=2003, 
#                                       "X2004"=2004, "X2005"=2005, "X2006"=2006, "X2007"=2007, "X2008"=2008, 
#                                       "X2009"=2009))
#wb_wdi <- melt(data = wb_wdi, id.vars = c("Country.Code"))
#wb_wdi <- rename(wb_wdi, replace = c("Country.Code"="actorid", "variable"="year", "value"="milper"))
#wb_wdi$actorid <- countrycode(wb_wdi$actorid, "wb", "cown")
#wb_wdi <- subset(wb_wdi, !is.na(wb_wdi$actorid))
#save(wb_wdi, file = "Daten/World Bank WDI/Milper.RData")


load("Daten/SIPRI Military Expenditure/SIPRI_milexp_1989-2009.RData")
#load("Daten/World Bank WDI/Milper.RData")
tq <- join(sipri, wdi, type="full", by=c("actorid", "year"), match="all")

tq$troop_quality <- tq$milexp / tq$milper
tq <- subset(tq, !is.na(tq$troop_quality), c(actorid, year, troop_quality))
tq$troop_quality_log <- log(tq$troop_quality)
tq$year <- as.numeric(as.character(tq$year))
Master <- join(Master, tq, type="left", by=c("actorid", "year"), match="all")

rm(wdi, sipri, tq)

##
## Import, process and save SIPRI data as RData object
## csv-file was manually saved and processed ("," to "."; adjusted some countrycodes etc.)
## (one time process)
## 

# sipri <- read.csv("Daten/SIPRI Military Expenditure/SIPRI_milexp_1989-2009.csv", sep=";", header = T)
# sipri$actorid <- countrycode(sipri$Country, "country.name", "cown")
# sipri <- rename(sipri, replace = c("X1989"=1989, "X1990"=1990, "X1991"=1991, "X1992"=1992, "X1993"=1993, 
#                                       "X1994"=1994, "X1995"=1995, "X1996"=1996, "X1997"=1997, "X1998"=1998, 
#                                       "X1999"=1999, "X2000"=2000, "X2001"=2001, "X2002"=2002, "X2003"=2003, 
#                                       "X2004"=2004, "X2005"=2005, "X2006"=2006, "X2007"=2007, "X2008"=2008, 
#                                       "X2009"=2009))
# sipri <- subset(sipri, select = c(-Country))
# sipri <- melt(data = sipri, id.vars = c("actorid"))
# sipri <- rename(sipri, replace = c("variable"="year", "value"="milexp"))
# save(sipri, file = "Daten/SIPRI Military Expenditure/SIPRI_milexp_1989-2009.RData")